/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpNodeDescriptions;
import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.GraphInstance;
import ibm.nways.analysis.dpCommon.MultipleNodePOAnalysis;
import ibm.nways.analysis.dpCommon.ResourceDefinition;
import ibm.nways.analysis.dpCommon.SingleNodeResourceAnalysis;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.analysis.dpCommon.ViewInstance;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.ras.Traces;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class NhmDataRetriever {
    private static DpmClientApplet dpmClient = null;

    public NhmDataRetriever(String string, int n) {
        if (dpmClient == null) {
            this.lookupDpManager(string, n);
        }
    }

    public SingleNodeResourceAnalysis retrieveSingleNodeAnalysis(String string, String string2, DpResourceInstance dpResourceInstance, Date date, Date date2) {
        SingleNodeResourceAnalysis singleNodeResourceAnalysis = null;
        Vector<String> vector = null;
        if (dpResourceInstance != null && dpResourceInstance.size() > 0) {
            vector = new Vector<String>();
            vector.addElement(dpResourceInstance.getIndexString());
        }
        try {
            singleNodeResourceAnalysis = dpmClient.analyzeResource(string, string2, vector, date.getTime(), date2.getTime());
        }
        catch (RemoteException remoteException) {
            Traces.logError(this, "RemoteException caught trying to retrieve Single Node analysis: " + string);
            Traces.logException(remoteException);
        }
        return singleNodeResourceAnalysis;
    }

    public MultipleNodePOAnalysis retrieveMultipleNodeAnalysis(String[] stringArray, DpResourceInstance[] dpResourceInstanceArray, String string, Date date, Date date2) {
        MultipleNodePOAnalysis multipleNodePOAnalysis = null;
        try {
            Vector[] vectorArray = new Vector[dpResourceInstanceArray.length];
            int n = 0;
            while (n < dpResourceInstanceArray.length) {
                if (dpResourceInstanceArray[n] != null && dpResourceInstanceArray[n].size() > 0) {
                    vectorArray[n] = new Vector();
                    vectorArray[n].addElement(dpResourceInstanceArray[n].getIndexString());
                } else {
                    vectorArray[n] = null;
                }
                ++n;
            }
            multipleNodePOAnalysis = dpmClient.analyzePollingObject(stringArray, string, vectorArray, date.getTime(), date2.getTime());
        }
        catch (RemoteException remoteException) {
            Traces.logError(this, "RemoteException caught trying to retrieve Multiple Node analysis: " + string);
            Traces.logException(remoteException);
        }
        return multipleNodePOAnalysis;
    }

    public ThresholdAnalysis retrieveThresholdAnalysis(String string, String string2, String string3, Date date, Date date2) {
        ThresholdAnalysis thresholdAnalysis = null;
        try {
            thresholdAnalysis = dpmClient.evaluateThresholds(string, string2, string3, date.getTime(), date2.getTime());
        }
        catch (RemoteException remoteException) {
            Traces.logError(this, "RemoteException caught trying to retrieve Threshold analysis: " + string);
            Traces.logException(remoteException);
        }
        return thresholdAnalysis;
    }

    public ViewInstance getViewInstance(String string, DpNodeDescriptions dpNodeDescriptions, DpResourceInstance dpResourceInstance, Date date, Date date2) {
        ViewInstance viewInstance = null;
        try {
            long l = -1L;
            if (date2 != null) {
                l = date2.getTime();
            }
            viewInstance = dpmClient.getViewInstance(string, dpNodeDescriptions, dpResourceInstance, date.getTime(), l);
            viewInstance.setupGraphData(dpmClient);
        }
        catch (RemoteException remoteException) {
            Traces.logError(this, "Remote Exception caught trying to get view instance for " + string + ": ");
            Traces.logException(remoteException);
        }
        return viewInstance;
    }

    public ViewInstance getMultipleViewInstances(String string, DpNodeDescriptions dpNodeDescriptions, DpResourceInstance[] dpResourceInstanceArray, Date date, Date date2) {
        ViewInstance viewInstance = null;
        try {
            long l = -1L;
            if (date2 != null) {
                l = date2.getTime();
            }
            int n = 0;
            while (n < dpResourceInstanceArray.length) {
                String string2 = (String)dpNodeDescriptions.elementAt(n);
                ViewInstance viewInstance2 = dpmClient.getViewInstance(string, string2, dpResourceInstanceArray[n], date.getTime(), l);
                if (viewInstance == null) {
                    viewInstance = viewInstance2;
                } else {
                    Enumeration enumeration = viewInstance2.getGraphs().elements();
                    int n2 = 0;
                    while (enumeration.hasMoreElements()) {
                        GraphInstance graphInstance = (GraphInstance)enumeration.nextElement();
                        GraphInstance graphInstance2 = (GraphInstance)viewInstance.getGraphs().elementAt(n2);
                        graphInstance2.addPollingObjectInstances(graphInstance.getPollingObjectInstances());
                        ++n2;
                    }
                }
                ++n;
            }
            viewInstance.setupGraphData(dpmClient);
        }
        catch (RemoteException remoteException) {
            Traces.logError(this, "Remote Exception caught trying to get view instance for " + string + ": ");
            Traces.logException(remoteException);
        }
        return viewInstance;
    }

    public Vector getPollingDefinitions(String string) {
        Vector vector = null;
        try {
            ResourceDefinition resourceDefinition = dpmClient.getResourceDefinition(string);
            if (resourceDefinition != null) {
                vector = resourceDefinition.getDefinitionVector();
            }
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
        }
        return vector;
    }

    public String getReportSetting(String string) {
        String string2 = null;
        try {
            string2 = dpmClient.getReportSetting(string);
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
        }
        return string2;
    }

    public void setReportSetting(String string, String string2) {
        try {
            dpmClient.setReportSetting(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
            return;
        }
    }

    public void stopPollingNode(String string) {
        try {
            dpmClient.unManageNode(string);
            return;
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
            return;
        }
    }

    public Vector getNodeList() {
        Vector vector = null;
        try {
            vector = dpmClient.getResourceNodeList();
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
        }
        return vector;
    }

    public Vector getEvents(EventFilter eventFilter) {
        Vector vector = null;
        try {
            vector = dpmClient.getEvents(eventFilter);
        }
        catch (RemoteException remoteException) {
            Traces.logException(remoteException);
        }
        return vector;
    }

    private void lookupDpManager(String string, int n) {
        try {
            String string2 = "rmi://";
            string2 = string2.concat(string);
            string2 = string2.concat(":");
            string2 = string2.concat(String.valueOf(n));
            string2 = string2.concat("/dpServer");
            dpmClient = (DpmClientApplet)Naming.lookup(string2);
            return;
        }
        catch (Exception exception) {
            Traces.logError(this, "Exception handled looking up dpServer in rmiRegistry ");
            Traces.logException(exception);
            return;
        }
    }
}

